require( "scripts/style.lua" );

function trim(str)
    return string.gsub(str, "^[%s\n]*(.-)[%s\n]*$", "%1")
end

gLevelSelected = 0;
gLevel = GetNextNonPlayedLevel();

SetState("StoryModeSessionTime",0);
SetState("MainMenuScreenTime",1);
SetState("ComicScreenTime",0);
SetState("MetaMapTime",0);
SetState("HelpScreenTime",0);

gMode = "story";


function process() 
	
	if (gLevelSelected > 0) then 
		gLevel = gLevelSelected;
	end
	
	SwapToModal("scripts/metamap.lua");
end

function CheckUsers()
	if (GetNumUsers() == 0) then
		gEnterNameValue = "";
		SendGameMessage("comic_music");
		name = DoModal("scripts/entername.lua");
		if (not(name == nil)) then
			if (not(trim(name) == "")) then
				CreateNewUser(trim(name));
				return true ;
			end
		end
		return false ;
	else
		return (GetNumUsers() > 0);
	end
end

function StartGame()
	if (CheckUsers()) then
		process();
	end
end

function StartEndlessShift() 
	if ( IsFirstPeek() ) then
		nothing = 0;
	else
		if (CheckUsers()) then		
			gMode = "endless";
			SwapToModal("scripts/metamap.lua");
		end
	end
end 

function ShowHighScores()
	if ( IsFirstPeek() ) then
	else
		if (GetNumUsers() == 0) then
			gEnterNameValue = "";
			SendGameMessage("comic_music");
			name = DoModal("scripts/entername.lua");
			if (not(name == nil) and not(name == "")) then
				CreateNewUser(name);
				DoModal("scripts/hiscore.lua");
			end
		else
			SendGameMessage("comic_music");
			DoModal("scripts/hiscore.lua");
		end
	end
end

function ShowHelp()
	SendGameMessage("comic_music");
	DoModal("scripts/help.lua");
end

function ShowOptions()
	SendGameMessage("comic_music");
	DoModal("scripts/options.lua");
end

function EndGame()
		
		SendGameMessage("comic_music");
		result = DisplayDialog {
			"scripts/yesno.lua",
			body ="quitconfirm",
			title = "quittitle"
		};
		if (result=='yes') then
			PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
		end
end

function ChangePlayer()
	SendGameMessage("comic_music");
	DoModal("scripts/chooseplayer.lua");
	PostMessage( CreateNamedMessage( kButtonPress, "PlayerChanged" ) );
end

-- DEBUG !!
function SelectLevel()
	gLevelSelected = tonumber(DoModal("scripts/selectlevel.lua"));
end



---------- SOME BUTTON PARAMETERS ----------
vButtonsDef_x 	=  100;
vButtonsDef_y 	= -308+40;
vBtnWidth		=  200;
vBtnHeight 		=   40;
vDefBtnHeight   =   82;
-------------------------------------------------------

vHSButtonFontStyle = { standardFont, 16, BlackColor };

LeftButtonGraphics = {
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
};

MakeDialog
{
	Bitmap
	{
		name	= "backgroundimage",
		image	= "backgrounds/welcomem.jpg",
			
		Welcome
		{
			-- Name the modal dialog
			name	= "Welcome",
			x 		= kCenter,
			y 		= kCenter,
			w 		= kMax,
			h 		= kMax,
			
			specialtext_storymode 	= "gamemode1",
			specialtext_endless  	= "gamemode2",
			
		
			SetStyle(MenuButtonStyle),
			SetStyle(LongButtonStyle),
			Button
			{
				label    	= "xsell",
				itemtext 	= "xsell",
				name     	= "btn_xsell",
				type     	= kPush,
				x 			= 450+vButtonsDef_x,
				y 			= 40,
				w			= 100,
				h			= 20,
				--flags 		= kHAlignCenter,
				rotation	= 20,
				command		= function()
								DoModal("xsell/xsell.lua");
							  end
			},
			SetStyle(MenuButtonStyle),
			SetStyle(ButtonStyle),	
			Button
			{
				label    	= "gamemode1",
				itemtext 	= "gamemode1",
				name     	= "btn_storymode",
				type     	= kPush,
				x 			= 569,
				y 			= 114,
				w			= 185,
				h			= 78,
				flags 		= kHAlignCenter + kVAlignCenter,
				rotation	= 20,
				font	= { "fonts/rollout.mvec", 34-2, BlackColor },
				command		= function()
								StartGame();
							  end
			},
			Button
			{
				label    	= "gamemode2",
				itemtext 	= "gamemode2",
				name     	= "btn_endlessshift",
				type     	= kPush,
				x 			= 618, 
				y 			= 207,
				w			= 169,
				h			= 74,
				flags 		= kHAlignCenter + kVAlignCenter,
				font	= { "fonts/rollout.mvec", 24-1, BlackColor },
				command		= function()
								StartEndlessShift();
							  end;
			},
			Button
			{
				label    	= "howtoplay",
				itemtext 	= "howtoplay",
				name     	= "btn_howtoplay",
				type     	= kPush,
				x 			= 632, 
				y 			= 301,
				w			= 160,
				h			= 56,
				flags 		= kHAlignCenter + kVAlignCenter,
				font	= { "fonts/rollout.mvec", 24-1, BlackColor },
				command		= function()
								SendGameMessage("new_screen");
								ShowHelp();
							  end;
			},
			
			Button
			{
				label    	= "highscores",
				itemtext 	= "highscores",
				name     	= "btn_topscore",
				type     	= kPush,
				x 			= 603, 
				y 			= 370,
				w			= 155,
				h			= 52,
				flags 		= kHAlignCenter + kVAlignCenter,
				font	= { "fonts/rollout.mvec", 24-2, BlackColor },
				command		= function()
								SendGameMessage("new_screen");
								ShowHighScores();
							  end;
			},
			
			Button
			{
				label    	= "options",
				itemtext 	= "options",
				name     	= "btn_options",
				type     	= kPush,
				x 			= 600, 
				y 			= 435,
				w			= 165,
				h			= 57,
				flags 		= kHAlignCenter + kVAlignCenter,
				font	= { "fonts/rollout.mvec", 22+2+2, BlackColor },
				command		= function()
								SendGameMessage("new_screen");
								ShowOptions();
							  end;
			},
			Button
			{
				label    	= "quit",
				itemtext 	= "quit",
				name     	= "btn_quit",
				type     	= kPush,
				x 			= 640, 
				y 			= 554,
				w			= 165,
				h			= 32,
				flags 		= kHAlignCenter + kVAlignCenter,
				font	= { "fonts/rollout.mvec", 22, BlackColor },
				command		= function()
								SendGameMessage("new_screen");
								EndGame();
							  end;
			},
			
			SetStyle(DialogBodyText),
			Text
			{
				x		= 515,
				y 		= 2,
				w		= 300,
				h		= 30,
				flags 	= kHAlignLeft + kVAlignBottom,
				label  	= "copyright",
				font	= { "fonts/rollout.mvec", 15, WhiteColor },
			},
			
			-----------------------change player
			SetStyle(ButtonStyle),	
			Button
			{
				label    	= "changeplayer",
				itemtext 	= "changeplayer",
				name     	= "btn_changeplayer",
				type     	= kPush,
				font =  {
					  standardFont,
					  18,
					  Color(0,0,0,255)
					},
				x 			= 430+40, 
				y 			= 460+100+2,
				flags 		= kHAlignCenter + kVAlignCenter,
				graphics	= { "buttons/changeplayer_norm", "buttons/changeplayer_over", "buttons/changeplayer_over" },
				command		= function()
								SendGameMessage("new_screen");
								ChangePlayer();
							  end;
			},
		},
		
	},
}

--FunctionsTable = { startgame=StartGame, endlessgame=StartEndlessShift };

--SetFocus( "Welcome" );